Rem
Rem $Header: ncmpdemo.sql 29-apr-2005.12:04:16 nmeng Exp $
Rem
Rem ncmpdemo.sql
Rem
Rem Copyright (c) 2002, 2005, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      ncmpdemo.sql - Demo program for PL/SQL NCOMP
Rem
Rem    DESCRIPTION
Rem      This demo program will show the performance improvement when compiling 
Rem      PL/SQL procedures into native code 
Rem
Rem    NOTES
REM 
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    nmeng       04/29/05  - refined query
Rem    mvemulap    06/26/03  - obsolete params
Rem    jxluo       08/23/02 -  use Rem for comments
Rem    jxluo       06/25/02 - jxluo_create_ncmp_demo
Rem    jxluo       06/24/02 - Created
Rem

REM Please use following instructions to run this demo.


REM 1. Create $ORACLE_HOME/dbs/plsqlnld directory. This directory will hold 
REM    natively compiled objects.

REM 2. Make sure the command template(s) in  $ORACLE_HOME/plsql/spnc_commands
REM    are correct.

REM 3. Connect as System using SQL*Plus and run following commands. Must replace
REM    $ORACLE_HOME with complete path.

REM alter system set plsql_native_library_dir = '$ORACLE_HOME/dbs/plsqlnld';
REM alter system set plsql_code_type = 'INTERPRETED';

REM 4. Run following query to verify if parameter values are set properly or not.


Set LineSize 140
Column name Format a35
Column value Format a90
select name, upper(value) from v$parameter 
  where lower(name) in ('plsql_compiler_flags',
                        'plsql_native_library_dir',
                        'plsql_code_type');


REM
REM 5. Connect as a regular user and run rest of the statements in this script.
REM

connect scott/tiger
set echo off

alter session set plsql_code_type = 'NATIVE';

create or replace procedure Hello is
begin
  Dbms_Output.Put_Line ( 'Hello NATIVE' );
end Hello;
/
show errors

REM Check if the procedure is compiled for native execution
select param_value from user_stored_settings
  where param_name = 'plsql_code_type'
  and object_name = 'HELLO'
  and object_type = 'PROCEDURE';


REM 
REM The result should be

REM PARAM_VALUE
REM ----------------
REM NATIVE
REM 

Set ServerOutput On
Execute Hello

REM 
REM 
REM Verify that shared library object is generated.

REM $ cd $ORACLE_HOME/dbs/plsqlnld
REM $ ls -l

REM We should see something like following (the file extension depends on
REM the platform):

REM -rwxr-xr-x   1 oracle   dba         4392 Jun 20 15:32 HELLO__SCOTT__P.so
REM 


REM 
REM Perfect_Triangles is a compute intensive procedure which we are using
REM to show that Natively Compiled Procedures run much faster than regular 
REM ones.
REM 

REM 
REM Perfect_Triangles procedure finds all right angled triangles (using
REM Pythagoras) with all side lengths integer. It does not count integral
REM multiples of ones already found.
REM 


create or replace procedure Perfect_Triangles ( p_max in integer ) is
  t1 integer; t2 integer;
  long integer; short integer; hyp number; ihyp integer;

  type side_r is record ( short integer, long integer );
  type sides_t is table of side_r index by binary_integer;
  unique_sides sides_t; n integer:=0 /* curr max elements in "unique_sides" */;
  dup_sides sides_t;    m integer:=0 /* curr max elements in "dup_sides" */;

  procedure Store_Dup_Sides  ( p_long in integer, p_short in integer ) is
    mult integer:=2; long_mult integer:=p_long*2; short_mult integer:=p_short*2;
  begin
    while ( long_mult < p_max ) or ( short_mult < p_max )
    loop
      n := n+1;
      dup_sides(n).long := long_mult; dup_sides(n).short := short_mult;
      mult := mult+1; long_mult := p_long*mult; short_mult := p_short*mult;
    end loop;
  end Store_Dup_Sides;

  function Sides_Are_Unique ( p_long in integer, p_short in integer )
    return boolean is
  begin
    for j in 1..n
    loop
      if ( p_long = dup_sides(j).long ) and ( p_short = dup_sides(j).short )
        then return false; end if;
    end loop;
    return true;
  end Sides_Are_Unique;

begin
  t1 := Dbms_Utility.Get_Time;
  for long in 1..p_max
  loop
    for short in 1..long
    loop
      hyp := Sqrt ( long*long + short*short ); ihyp := Floor(hyp);
      if hyp-ihyp < 0.01
      then
        if ( ihyp*ihyp = long*long + short*short )
        then
          if Sides_Are_Unique ( long, short )
          then
            m := m+1;
            unique_sides(m).long := long; unique_sides(m).short := short;
            Store_Dup_Sides ( long, short );
          end if;
        end if;
      end if;
    end loop;
  end loop;
  t2 := Dbms_Utility.Get_Time;

/*
  for j in 1..m
  loop
    Dbms_Output.Put_Line ( '.' ||
      Lpad(unique_sides(j).long, 4,' ') ||
      Lpad(unique_sides(j).short,4,' ') );
  end loop;
*/


  Dbms_Output.Put_Line (To_Char( ((t2-t1)/100), '9999.9' ) || ' seconds' );

end Perfect_Triangles;
/
Show Errors

REM Check if the procedure is compiled for native execution

select param_value from user_stored_settings
  where param_name = 'plsql_code_type'
  and object_name = 'PERFECT_TRIANGLES'
  and object_type = 'PROCEDURE';

REM 
REM The result should be
REM 
REM PARAM_VALUE
REM ---------------------
REM NATIVE
REM 

Set ServerOutput On
Execute  Perfect_Triangles ( 1000 )

REM Run the procedure using INTERPRETED mode.

alter session set plsql_code_type = 'INTERPRETED';
alter procedure  Perfect_Triangles  compile;

REM Check if the procedure is compiled for interpreted execution

select param_value from user_stored_settings
  where param_name = 'plsql_code_type'
  and object_name = 'PERFECT_TRIANGLES'
  and object_type = 'PROCEDURE';

REM 
REM The result should be
REM 
REM PARAM_VALUE
REM ---------------------
REM INTERPRETED
REM 

Set ServerOutput On
Execute  Perfect_Triangles ( 1000 )
